<?php
/* --------------------------------------------------------------
   WithdrawalSortings.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Withdrawal\SqlCriteria;

use ArrayIterator;
use Gambio\Core\Criteria\SqlSortings;
use Traversable;

/**
 * Class WithdrawalSortings
 *
 * @package Gambio\Admin\Withdrawal\SqlCriteria
 */
class WithdrawalSortings implements SqlSortings
{
    /**
     * @var WithdrawalSorting[]
     */
    private $sortings;
    
    
    /**
     * WithdrawalSortings constructor.
     *
     * @param WithdrawalSorting ...$sortings
     */
    private function __construct(WithdrawalSorting ...$sortings)
    {
        $this->sortings = $sortings;
    }
    
    
    /**
     * @param WithdrawalSorting ...$sortings
     *
     * @return WithdrawalSortings
     */
    public static function create(WithdrawalSorting ...$sortings): WithdrawalSortings
    {
        return new self(...$sortings);
    }
    
    
    /**
     * @param WithdrawalSorting ...$sortings
     *
     * @return $this
     */
    public function add(WithdrawalSorting ...$sortings): self
    {
        $this->sortings = array_merge($this->sortings, $sortings);
        
        return $this;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getIterator(): Traversable
    {
        return new ArrayIterator($this->sortings);
    }
}